#!/bin/bash

[[ $EUID != 0 ]] && {
    echo "This script requires root permissions"
    exit 1
}

# delete and recreate miniatos-db
echo "-- start couchdb"
systemctl start couchdb

echo "-- stop application"
systemctl stop fwapp-server

DBADMIN=dbadmin
ADMINPW=potato5620

DB=miniatos_db

while [ -z "$alldbs" ]; do
    sleep 0.5
    alldbs=`curl -s http://${DBADMIN}:${ADMINPW}@127.0.0.1:5984/_all_dbs`
done

miniatos_db_exists=`echo "$alldbs" | grep "$DB"`
if [ -n $miniatos_db_exists ]; then
    echo "-- delete miniatos_db"
    # 1. delete db 'miniatos_db'
    curl -X DELETE http://${DBADMIN}:${ADMINPW}@127.0.0.1:5984/$DB

fi

echo "-- recreate miniatos_db"
# 2. create db 'miniatos_db'
curl -X PUT http://${DBADMIN}:${ADMINPW}@127.0.0.1:5984/$DB

# 3. add user to $DB admins (not couchdb admin)
curl -X PUT http://127.0.0.1:5984/$DB/_security \
    -u  $DBADMIN:$ADMINPW \
    -H "Content-Type: application/json" \
    -d '{"admins": { "names": [], "roles": ["miniatos_db_admin"] }, "members": { "names": [], "roles": [] } }'
