#!/bin/bash

[[ $EUID != 0 ]] && {
    echo "This script requires root permissions"
    exit 1
}

function sortableVersion { echo "$@" | awk -F. '{ printf("%03d%03d%05d%05d\n", $1,$2,$3,$4); }'; }

firmwareDir="/opt/firmware/act"
oldFirmwareDir="/opt/firmware/old"

chmod 0755 $firmwareDir/Raytech.WebUI.Server
chmod 0755 $firmwareDir/spitemp
chmod 0755 $firmwareDir/update-hardware
chmod 0755 $firmwareDir/Starter
chmod u+s $firmwareDir/Starter

# delete chromium cache
rm -r -f "/home/display/.cache/chromium"
rm -r -f "/home/display/.config/chromium"
rm -r -f "/home/weston/.cache/chromium"
rm -r -f "/home/weston/.config/chromium"

# delete old log files
rm -f /var/www/mini-atos-log/archives/*.log
rm -f /var/www/mini-atos-log/communication.log



# update hardware
$firmwareDir/update-hardware

# if /data/db doesn't exists, it's the initial installation
if [ -d "/data/db" ]; then

    oldRevision=$(if [ -e "$oldFirmwareDir/REVISION" ]; then cat "$oldFirmwareDir/REVISION"; else echo "99.99.99"; fi)

    # check revision: if empty something goes wrong during last update. Do nothing.
    if [[ ! -z "${oldRevision-}" ]]; then 
        oldSortableRevision=$(sortableVersion $oldRevision)

        if [ $oldSortableRevision -lt $(sortableVersion '0.99.04') ]; then
            . $firmwareDir/scripts/recreate-database.sh
        fi
    fi
fi

# exit 0 to continue update process
exit 0
